// This file contains a simple program to write the inputs to the shared DLL, so the simulator
// can read them...

#include <windows.h>
#include <stdio.h>
#define FALSE 0
#define TRUE 1
typedef void (_stdcall *dll_setup_ptr)(void);
typedef void (_stdcall *dll_func_ptr)(float zin, float zangle, float headangle, float degrees, float topdown);
typedef void (_stdcall *dll_whiteout_ptr)(float min_seconds, float max_seconds, float percent_chance);
typedef void (_stdcall *dll_object_ptr)(int object, float dampen, float return_force, float soft_force, float hard_force, float weight);
typedef void (_stdcall *dll_twiddle_ptr)(int value);

HINSTANCE dll_handle;
dll_setup_ptr dll_setup_memory_mapped_file;
dll_func_ptr dll_give_inputs_to_simulator;
dll_whiteout_ptr dll_give_whiteout_values_to_simulator;
dll_object_ptr dll_give_object_values_to_simulator;
dll_twiddle_ptr dll_show_tally;
dll_twiddle_ptr dll_start_animation;


//------------------------------------------------------------------------------------
void input_dll_cleanup(void)
{
    // <ZZ> Free up our library when it's no longer needed...
    printf("Closing our DLL\n");
    FreeLibrary(dll_handle);
}

//------------------------------------------------------------------------------------
void input_dll_setup()
{
    // <ZZ> This function sets up the DLL that's used as a middle man between the
    //      main control input application and the simulation program


    printf("Setting up the DLL to set control inputs\n");
    dll_handle = LoadLibrary("EndoDLL.dll");
    if(dll_handle == NULL)
    {
        printf("ERROR:  Couldn't load EndoDLL.dll\n");
        return;
    }


    dll_setup_memory_mapped_file = (dll_setup_ptr) GetProcAddress(dll_handle, "setup_memory_mapped_file");
    if(dll_setup_memory_mapped_file == NULL)
    {
        printf("ERROR:  Couldn't find setup_memory_mapped_file() function\n");
        return;
    }



    dll_give_inputs_to_simulator = (dll_func_ptr) GetProcAddress(dll_handle, "give_inputs_to_simulator");
    if(dll_give_inputs_to_simulator == NULL)
    {
        printf("ERROR:  Couldn't find give_inputs_to_simulator() function\n");
        return;
    }


    dll_give_whiteout_values_to_simulator = (dll_whiteout_ptr) GetProcAddress(dll_handle, "give_whiteout_values_to_simulator");
    if(dll_give_whiteout_values_to_simulator == NULL)
    {
        printf("ERROR:  Couldn't find give_whiteout_values_to_simulator() function\n");
        return;
    }


    dll_give_object_values_to_simulator = (dll_object_ptr) GetProcAddress(dll_handle, "give_object_values_to_simulator");
    if(dll_give_object_values_to_simulator == NULL)
    {
        printf("ERROR:  Couldn't find give_object_values_to_simulator() function\n");
        return;
    }



    dll_show_tally = (dll_twiddle_ptr) GetProcAddress(dll_handle, "show_tally");
    if(dll_show_tally == NULL)
    {
        printf("ERROR:  Couldn't find show_tally() function\n");
        return;
    }


    dll_start_animation = (dll_twiddle_ptr) GetProcAddress(dll_handle, "start_animation");
    if(dll_start_animation == NULL)
    {
        printf("ERROR:  Couldn't find start_animation() function\n");
        return;
    }



    printf("Trying to call setup_memory_mapped_file()\n");
    dll_setup_memory_mapped_file();
    atexit(input_dll_cleanup);
}

//-----------------------------------------------------------------------------------------------
int main(void)
{
    float zin, percentage, hard_force, temp;
    int object, value;
    input_dll_setup();
    dll_show_tally(TRUE);
    printf("Hello...\n");
    while(TRUE)
    {
        printf("Please type your value for zin (less than 0 quits)...  ");
        scanf("%f", &zin);
        if(zin < 0.0f) { return TRUE; }
        dll_give_inputs_to_simulator(zin, 17.0f, 13.0f, TRUE, FALSE);

        printf("Please type your value for whiteout percentage (less than 0 quits)...  ");
        scanf("%f", &percentage);
        if(percentage < 0.0f) { return TRUE; }
        dll_give_whiteout_values_to_simulator(2.0f, 5.0f, percentage);

        printf("Please type the object you would like to modify (less than 0 quits)...  ");
        scanf("%d", &object);
        if(object < 0) { return TRUE; }

        printf("Please type your value for hard force (less than 0 quits)...  ");
        scanf("%f", &hard_force);
        if(hard_force < 0.0f) { return TRUE; }
        dll_give_object_values_to_simulator(object, 0.10f, 0.03f, 0.20f, hard_force, 1.00f);

        printf("Please type 0 to hide tally, 1 to show tally, 2 to start animation (less than 0 quits)");
        scanf("%f", &temp);
        if(temp < 0.0f) { return TRUE; }
        value = (int) temp;
        if(value == 0)
        {
            dll_show_tally(FALSE);
        }
        if(value == 1)
        {
            dll_show_tally(TRUE);
        }
        if(value == 2)
        {
            dll_start_animation(1);
        }
    }
    return TRUE;
}

//------------------------------------------------------------------------------------
