// <ZZ> This file contains functions for particles...

//-----------------------------------------------------------------------------------------------
void particle_draw(float* current_xyz, float radius, unsigned int texture)
{
    // <ZZ> This function draws all the particles...
    float corner_xyz[4][3];


    display_zbuffer_write_on();
    display_cull_off();
    display_texture_on();
    display_blend_off();
    display_shade_off();
    display_pick_texture(texture);
    display_color_alpha(white);
    display_paperdoll_on();
    display_paperdoll_func(192);




    // Figger the coordinates of the 4 onscreen corners for the particle's current position...
    // Top Left...
    corner_xyz[0][X] = current_xyz[X] + (-camera_side_xyz[X] + camera_up_xyz[X])*radius;
    corner_xyz[0][Y] = current_xyz[Y] + (-camera_side_xyz[Y] + camera_up_xyz[Y])*radius;
    corner_xyz[0][Z] = current_xyz[Z] + (-camera_side_xyz[Z] + camera_up_xyz[Z])*radius;
    // Top Right...
    corner_xyz[1][X] = current_xyz[X] + (camera_side_xyz[X] + camera_up_xyz[X])*radius;
    corner_xyz[1][Y] = current_xyz[Y] + (camera_side_xyz[Y] + camera_up_xyz[Y])*radius;
    corner_xyz[1][Z] = current_xyz[Z] + (camera_side_xyz[Z] + camera_up_xyz[Z])*radius;
    // Bottom Right...
    corner_xyz[2][X] = current_xyz[X] + (camera_side_xyz[X] - camera_up_xyz[X])*radius;
    corner_xyz[2][Y] = current_xyz[Y] + (camera_side_xyz[Y] - camera_up_xyz[Y])*radius;
    corner_xyz[2][Z] = current_xyz[Z] + (camera_side_xyz[Z] - camera_up_xyz[Z])*radius;
    // Bottom Left...
    corner_xyz[3][X] = current_xyz[X] + (-camera_side_xyz[X] - camera_up_xyz[X])*radius;
    corner_xyz[3][Y] = current_xyz[Y] + (-camera_side_xyz[Y] - camera_up_xyz[Y])*radius;
    corner_xyz[3][Z] = current_xyz[Z] + (-camera_side_xyz[Z] - camera_up_xyz[Z])*radius;


    // Draw the particle...
    display_start_fan();
        display_texpos_xy(0.0f, 0.0f);  display_vertex(corner_xyz[0]);
        display_texpos_xy(1.0f, 0.0f);  display_vertex(corner_xyz[1]);
        display_texpos_xy(1.0f, 1.0f);  display_vertex(corner_xyz[2]);
        display_texpos_xy(0.0f, 1.0f);  display_vertex(corner_xyz[3]);
    display_end();



    display_paperdoll_off();
}

//-----------------------------------------------------------------------------------------------
