// File with all of the menu routines in it...
// Note: Font for menu images is Sans 15 in Gimp
float menu_dampen = 0.95f;
float filelist_dampen = 0.90f;
unsigned short current_menu_item;
unsigned short active_menu_item = 65535;
unsigned short fileslide_menu_item;
float filelist_position = 0.0f;

#define MAX_FILELIST 1024
unsigned char filelist_settings = FALSE;
unsigned short num_filelist = 0;
unsigned char filelist[MAX_FILELIST][256];


//------------------------------------------------------------------------------------
void menu_get_filelist(unsigned char* search_string)
{
    WIN32_FIND_DATA wfdData;
    HANDLE hFind;
    BOOL keeplooking;


    // Search for all files
    hFind = FindFirstFile(search_string, &wfdData);
    num_filelist = 0;
    keeplooking = TRUE;
    if(hFind != INVALID_HANDLE_VALUE)
    {
        while(keeplooking && num_filelist < MAX_FILELIST)
        {
            sprintf(filelist[num_filelist], "%s", wfdData.cFileName);
            keeplooking = FindNextFile(hFind, &wfdData);
            num_filelist++;
        }
    }
}

//------------------------------------------------------------------------------------
void menu_load_settings(unsigned char* filename)
{
    unsigned char fullname[1024];
    FILE* setfile;
    float temp;
    unsigned char text[8192];

    sprintf(fullname, "FILES\\%s", filename);
    log_message("INFO:   Attempting to read settings from %s", fullname);
    setfile = fopen(fullname, "r");
    if(setfile)
    {
        fscanf(setfile, "%[^:]:%f", text, &temp);  global_spring_force = temp;
        log_message("Read %f", temp);

        fscanf(setfile, "%[^:]:%f", text, &temp);  global_toothpick_force = temp;
        log_message("Read %f", temp);

        fscanf(setfile, "%[^:]:%f", text, &temp);  global_return_force = temp;
        log_message("Read %f", temp);

        fscanf(setfile, "%[^:]:%f", text, &temp);  global_dampen = temp;
        log_message("Read %f", temp);

        fscanf(setfile, "%[^:]:%f", text, &temp);  global_scope_spring_force = temp;
        log_message("Read %f", temp);

        fscanf(setfile, "%[^:]:%f", text, &temp);  global_scope_toothpick_force = temp;
        log_message("Read %f", temp);

        fscanf(setfile, "%[^:]:%f", text, &temp);  global_scope_dampen = temp;
        log_message("Read %f", temp);

        fscanf(setfile, "%[^:]:%f", text, &temp);  global_scope_radius = temp;
        log_message("Read %f", temp);

        fscanf(setfile, "%[^:]:%f", text, &temp);  global_scope_weight = temp;
        log_message("Read %f", temp);

        fscanf(setfile, "%[^:]:%f", text, &temp);  global_scope_control_points = (unsigned short) temp;
        log_message("Read %f", temp);

        fscanf(setfile, "%[^:]:%f", text, &temp);  global_scope_between_points = (unsigned short) temp;
        log_message("Read %f", temp);

        fscanf(setfile, "%[^:]:%f", text, &temp);  global_scope_stiffness = temp;
        log_message("Read %f", temp);

        fscanf(setfile, "%[^:]:%f", text, &temp);  global_scope_turn_stiffness = temp;
        log_message("Read %f", temp);

        fscanf(setfile, "%[^:]:%f", text, &temp);  global_scope_tip_stiffness = temp;
        log_message("Read %f", temp);

        fscanf(setfile, "%[^:]:%f", text, &temp);  global_scope_max_tip_angle = temp;
        log_message("Read %f", temp);

        fscanf(setfile, "%[^:]:%f", text, &temp);  global_ambient_light = temp;
        log_message("Read %f", temp);

        fscanf(setfile, "%[^:]:%f", text, &temp);  global_cam_light = temp;
        log_message("Read %f", temp);

        fscanf(setfile, "%[^:]:%f", text, &temp);  global_gravity = temp;
        log_message("Read %f", temp);

        fscanf(setfile, "%[^:]:%s", text, global_scope_length_text);
        sscanf(global_scope_length_text, "%f", &temp);  global_scope_length = temp;
        log_message("Read %f (string was %s)", temp, global_scope_length_text);

        fscanf(setfile, "%[^:]:%s", text, global_object_filename);
        log_message("Read %s", global_object_filename);

        fscanf(setfile, "%[^:]:%f", text, &temp);  global_object_scaling = temp;
        log_message("Read %f", temp);

        fscanf(setfile, "%[^:]:%f", text, &temp);  global_load_inverted = (unsigned char) temp;
        log_message("Read %f", temp);


        fclose(setfile);
    }
    else
    {
        log_message("File %s not found...", fullname);
    }
}

//------------------------------------------------------------------------------------
void menu_save_settings(unsigned char* filename)
{
    unsigned char fullname[1024];
    FILE* setfile;



    sprintf(fullname, "FILES\\%s", filename);
    log_message("INFO:   Attempting to write settings to %s", fullname);
    setfile = fopen(fullname, "w");
    if(setfile)
    {
        fprintf(setfile, "Initial settings for each parameter are loaded from this file...\n");
        fprintf(setfile, "\n");
        fprintf(setfile, "Mesh Soft: %4.2f\n", global_spring_force);
        fprintf(setfile, "Mesh Hard: %4.2f\n", global_toothpick_force);
        fprintf(setfile, "Mesh Return: %4.2f\n", global_return_force);
        fprintf(setfile, "Mesh Dampen: %4.2f\n", global_dampen);
        fprintf(setfile, "Scope Soft: %4.2f\n", global_scope_spring_force);
        fprintf(setfile, "Scope Hard: %4.2f\n", global_scope_toothpick_force);
        fprintf(setfile, "Scope Dampen: %4.2f\n", global_scope_dampen);
        fprintf(setfile, "Scope Radius: %4.2f\n", global_scope_radius);
        fprintf(setfile, "Scope Weight: %4.2f\n", global_scope_weight);
        fprintf(setfile, "Spline Controls: %d\n", global_scope_control_points);
        fprintf(setfile, "Spline Points: %d\n", global_scope_between_points);
        fprintf(setfile, "Scope Stiffness: %4.2f\n", global_scope_stiffness);
        fprintf(setfile, "Turn Stiffness: %4.2f\n", global_scope_turn_stiffness);
        fprintf(setfile, "Tip Stiffness: %4.2f\n", global_scope_tip_stiffness);
        fprintf(setfile, "Max Tip Angle: %4.2f\n", global_scope_max_tip_angle);
        fprintf(setfile, "Ambient Light: %4.2f\n", global_ambient_light);
        fprintf(setfile, "Cam Light: %4.2f\n", global_cam_light);
        fprintf(setfile, "Gravity: %4.2f\n", global_gravity);
        fprintf(setfile, "Scope Length: %4.2f\n", global_scope_length);
        fprintf(setfile, "File: %s\n", global_object_filename);
        fprintf(setfile, "Mesh Scaling: %4.2f\n", global_object_scaling);
        fprintf(setfile, "Load Inverted: %d\n", global_load_inverted);
        fclose(setfile);
    }
    else
    {
        log_message("Unable to open %s for writing...", fullname);
    }
}

//------------------------------------------------------------------------------------
void menu_update()
{
    // <ZZ> This function pulls down the menu...
    float inverse;

    inverse = 1.0f - menu_dampen;
    if(menu_open)
    {
        menu_y = menu_y*menu_dampen;
    }
    else
    {
        menu_y = menu_y*menu_dampen + -290.0f*inverse;
    }


    if(active_menu_item != 65535)
    {
        filelist_open = (filelist_open & active_menu_textbox) | (active_menu_item == fileslide_menu_item);
    }
    inverse = 1.0f - filelist_dampen;
    if(filelist_open)
    {
        filelist_x = filelist_x*filelist_dampen + 100.0f*inverse;
    }
    else
    {
        filelist_x = filelist_x*filelist_dampen - 100.0f*inverse;
    }
}

//-----------------------------------------------------------------------------------------------
void menu_slider(float inx, float iny, float* value, float maximum)
{
    // <ZZ> This function draws a slider, and allows the user to pull it around...
    float val;
    float x, y;
    unsigned char text[256];

    val = *value;
    if(active_menu_item == current_menu_item)
    {
        sprintf(text, "%f", val);  display_string(text, inx + 47.0f, iny, 10.0f, 255);
        display_pick_texture(slideon_texture);
    }
    else
    {
        display_pick_texture(slideoff_texture);
    }
    val = val/maximum;
    if(val < 0.0f) { val = 0.0f; }
    if(val > 1.0f) { val = 1.0f; }
    x = inx+(37.0f*val);
    y = iny;
    display_start_fan();
        display_texpos_xy(0.0f, 0.0f);  display_vertex_xy(0.0f+x, 0.0f+y);
        display_texpos_xy(1.0f, 0.0f);  display_vertex_xy(10.0f+x, 0.0f+y);
        display_texpos_xy(1.0f, 1.0f);  display_vertex_xy(10.0f+x, 10.0f+y);
        display_texpos_xy(0.0f, 1.0f);  display_vertex_xy(0.0f+x, 10.0f+y);
    display_end();


    if(mouse_pressed[0] || mouse_pressed[1] || mouse_pressed[2])
    {
        if(mouse_x > x && mouse_x < (x+10.0f))
        {
            if(mouse_y > y && mouse_y < (y+10.0f))
            {
                active_menu_item = current_menu_item;
                active_menu_textbox = FALSE;
            }
        }
    }
    if(active_menu_item == current_menu_item)
    {
        val = (mouse_x - inx - 5.0f) / 37.0f;
        if(val < 0.0f) { val = 0.0f; }
        if(val > 1.0f) { val = 1.0f; }
        *value = val*maximum;
    }
    current_menu_item++;
}

//-----------------------------------------------------------------------------------------------
void menu_vertical_slider(float inx, float iny, float* value, float maximum)
{
    // <ZZ> This function draws a vertical slider, and allows the user to pull it around...
    float val;
    float x, y;

    val = *value;
    if(active_menu_item == current_menu_item)
    {
        display_pick_texture(slideon_texture);
    }
    else
    {
        display_pick_texture(slideoff_texture);
    }
    val = val/maximum;
    if(val < 0.0f) { val = 0.0f; }
    if(val > 1.0f) { val = 1.0f; }
    x = inx;
    y = iny+(290.0f*val);
    display_start_fan();
        display_texpos_xy(0.0f, 0.0f);  display_vertex_xy(0.0f+x, 0.0f+y);
        display_texpos_xy(1.0f, 0.0f);  display_vertex_xy(10.0f+x, 0.0f+y);
        display_texpos_xy(1.0f, 1.0f);  display_vertex_xy(10.0f+x, 10.0f+y);
        display_texpos_xy(0.0f, 1.0f);  display_vertex_xy(0.0f+x, 10.0f+y);
    display_end();


    if(mouse_pressed[0] || mouse_pressed[1] || mouse_pressed[2])
    {
        if(mouse_x > x && mouse_x < (x+10.0f))
        {
            if(mouse_y > y && mouse_y < (y+10.0f))
            {
                active_menu_item = current_menu_item;
                active_menu_textbox = FALSE;
            }
        }
    }
    if(active_menu_item == current_menu_item)
    {
        val = (mouse_y - iny - 5.0f) / 290.0f;
        if(val < 0.0f) { val = 0.0f; }
        if(val > 1.0f) { val = 1.0f; }
        *value = val*maximum;
    }
    current_menu_item++;
}

//-----------------------------------------------------------------------------------------------
unsigned char menu_button(float x, float y, unsigned int up_texture, unsigned int down_texture)
{
    // <ZZ> This function draws a button and allows user to click it...
    unsigned char value;


    value = FALSE;
    if(mouse_pressed[0] || mouse_pressed[1] || mouse_pressed[2])
    {
        if(mouse_x > x && mouse_x < (x+47.0f))
        {
            if(mouse_y > y && mouse_y < (y+11.5f))
            {
                value = TRUE;
                active_menu_item = current_menu_item;
                active_menu_textbox = FALSE;
            }
        }
    }
    if(active_menu_item == current_menu_item)
    {
        display_pick_texture(down_texture);
    }
    else
    {
        display_pick_texture(up_texture);
    }
    display_start_fan();
        display_texpos_xy(0.0f, 0.0f);  display_vertex_xy(0.0f+x, 0.0f+y);
        display_texpos_xy(1.0f, 0.0f);  display_vertex_xy(47.0f+x, 0.0f+y);
        display_texpos_xy(1.0f, 1.0f);  display_vertex_xy(47.0f+x, 11.5f+y);
        display_texpos_xy(0.0f, 1.0f);  display_vertex_xy(0.0f+x, 11.5f+y);
    display_end();


    current_menu_item++;
    return value;
}

//------------------------------------------------------------------------------------
void menu_highlight_area(float x, float y, float width, float height, unsigned char* value, unsigned char r, unsigned char g, unsigned char b)
{
    // <ZZ> This function draws a highlight area for the given option...
    unsigned char color[3];
    unsigned char mouse_over;

    mouse_over = FALSE;
    color[0] = r;
    color[1] = g;
    color[2] = b;
    color[3] = 128;
    if(mouse_x > x && mouse_x < (x+width))
    {
        if(mouse_y > y && mouse_y < (y+height))
        {
            mouse_over = TRUE;
        }
    }
    if(mouse_over)
    {
        if(mouse_pressed[0] || mouse_pressed[1] || mouse_pressed[2])
        {
            (*value) = !(*value);
            active_menu_item = current_menu_item;
            active_menu_textbox = FALSE;
        }
    }
    if((*value) || mouse_over)
    {
        if(mouse_over)
        {
            if(*value)
            {
                color[0] = (255 + color[0])>>1;
                color[1] = (255 + color[1])>>1;
                color[2] = (255 + color[2])>>1;
            }
            else
            {
                color[0] = 255;
                color[1] = 255;
                color[2] = 255;
            }
        }
        display_color_alpha(color);
        display_blend_trans();
        display_texture_off();
        display_start_fan();
            display_texpos_xy(0.0f, 0.0f);  display_vertex_xy(0.0f+x, 0.0f+y);
            display_texpos_xy(1.0f, 0.0f);  display_vertex_xy(width+x, 0.0f+y);
            display_texpos_xy(1.0f, 1.0f);  display_vertex_xy(width+x, height+y);
            display_texpos_xy(0.0f, 1.0f);  display_vertex_xy(0.0f+x, height+y);
        display_end();
        display_texture_on();
        display_blend_off();
        display_color_alpha(white);
    }
    current_menu_item++;
}

//-----------------------------------------------------------------------------------------------
unsigned char menu_textbox(float x, float y, unsigned char* value, unsigned char length, unsigned char* search_string, unsigned char settings)
{
    // <ZZ> This function draws a textbox and allows the user to input text...
    //      Returns TRUE if the enter key was pressed...  If search_string is
    //      set, it also gets a directory list when clicked...
    unsigned char text[256];
    unsigned char letter;
    int temp;


    if((active_menu_item == current_menu_item) && (global_frame&16))
    {
        sprintf(text, "%s_", value);
    }
    else
    {
        sprintf(text, "%s", value);
    }


    display_string(text, x, y, 7.0f, (unsigned short) (length+2));


    if(mouse_pressed[0] || mouse_pressed[1] || mouse_pressed[2])
    {
        if(mouse_x > x && mouse_x < (x+(6.25f*length)))
        {
            if(mouse_y > y && mouse_y < (y+7.0f))
            {
                active_menu_item = current_menu_item;
                active_menu_textbox = TRUE;
                filelist_open = FALSE;
                if(search_string)
                {
                    menu_get_filelist(search_string);
                    filelist_settings = settings;
                    filelist_open = TRUE;
                    filelist_position = 0.0f;
                }
            }
        }
    }
    if(active_menu_item == current_menu_item)
    {
        if(last_key)
        {
            letter = 0;
            if(last_key >= SDLK_a && last_key <= SDLK_z)
            {
                letter = last_key - SDLK_a + 'A';
            }
            else if(last_key >= SDLK_0 && last_key <= SDLK_9)
            {
                letter = last_key - SDLK_0 + '0';
            }
            else if(last_key == SDLK_PERIOD)
            {
                letter = '.';
            }
            else if(last_key == SDLK_MINUS || last_key == SDLK_UNDERSCORE)
            {
                letter = '_';
            }
            else if(last_key == SDLK_BACKQUOTE)
            {
                letter = '~';
            }
            if(letter)
            {
                sprintf(text, "%s", value);
                sprintf(value, "%s%c", text, letter);
                value[length+1] = 0;
            }
            if(last_key == SDLK_DELETE || last_key == SDLK_BACKSPACE)
            {
                temp = strlen(value);
                if(temp > 0)
                {
                    temp--;
                    value[temp] = 0;
                }
            }
            if(last_key == SDLK_RETURN)
            {
                active_menu_item = 65535;
                current_menu_item++;
                return TRUE;
            }
        }
    }
    current_menu_item++;
    return FALSE;
}

//------------------------------------------------------------------------------------
void menu_draw()
{
    // <ZZ> This function draws the menu and allows user interaction...
    float x, y, y_add;
    float temp;
    int i, firstfile;
    int object;
    unsigned char picked;
    unsigned char text[256];
    unsigned char color_temp[4];



    // Figure out if the user clicked in the menu...
    if(mouse_pressed[0] || mouse_pressed[1] || mouse_pressed[2])
    {
        active_menu_item = 65535;
        active_menu_textbox = FALSE;
        menu_active = FALSE;
        if(mouse_x > 0.0f && (mouse_x < 100.0f || mouse_x < (filelist_x+100.0f)))
        {
            if(mouse_y > menu_y && mouse_y < (menu_y + 300.0f))
            {
                menu_active = TRUE;
            }
        }
        filelist_open = filelist_open & menu_active;
    }
    if(!mouse_down[0] && !mouse_down[1] && !mouse_down[2])
    {
        if(!active_menu_textbox)
        {
            active_menu_item = 65535;
        }
    }



    // Draw the window stuff...
    display_window_mode();
    display_zbuffer_off();
    display_cull_off();
    display_texture_on();
    display_shade_off();



    // Draw the whiteout effect...
    if(global_whiteout_amount > 0.0f && global_scope_cam)
    {
        color_temp[0] = (unsigned char) (global_whiteout_amount * 255.0f);
        color_temp[1] = color_temp[0];
        color_temp[2] = color_temp[0];
        display_color(color_temp);
        display_blend_light();
        display_pick_texture(whiteout_texture);
        display_start_fan();
            display_texpos_xy(0.0f, 0.0f);  display_vertex_xy(0.0f, 0.0f);
            display_texpos_xy(1.0f, 0.0f);  display_vertex_xy(400.0f, 0.0f);
            display_texpos_xy(1.0f, 1.0f);  display_vertex_xy(400.0f, 300.0f);
            display_texpos_xy(0.0f, 1.0f);  display_vertex_xy(0.0f, 300.0);
        display_end();
    }
    display_blend_off();
    display_color_alpha(white);



    // Draw the filepicker...
    display_pick_texture(menu_texture[3]);
    y = menu_y;
    x = filelist_x;
    display_start_fan();
        display_texpos_xy(0.0f, 0.01f);  display_vertex_xy(0.0f+x, 0.0f+y);
        display_texpos_xy(1.0f, 0.01f);  display_vertex_xy(100.0f+x, 0.0f+y);
        display_texpos_xy(1.0f, 0.10f);  display_vertex_xy(100.0f+x, 2.0f+y);
        display_texpos_xy(0.0f, 0.10f);  display_vertex_xy(0.0f+x, 2.0f+y);
    display_end();
    display_start_fan();
        display_texpos_xy(0.0f, 0.10f);  display_vertex_xy(0.0f+x, 2.0f+y);
        display_texpos_xy(1.0f, 0.10f);  display_vertex_xy(100.0f+x, 2.0f+y);
        display_texpos_xy(1.0f, 0.90f);  display_vertex_xy(100.0f+x, 298.0f+y);
        display_texpos_xy(0.0f, 0.90f);  display_vertex_xy(0.0f+x, 298.0f+y);
    display_end();
    display_start_fan();
        display_texpos_xy(0.0f, 0.90f);  display_vertex_xy(0.0f+x, 298.0f+y);
        display_texpos_xy(1.0f, 0.90f);  display_vertex_xy(100.0f+x, 298.0f+y);
        display_texpos_xy(1.0f, 0.99f);  display_vertex_xy(100.0f+x, 300.0f+y);
        display_texpos_xy(0.0f, 0.99f);  display_vertex_xy(0.0f+x, 300.0f+y);
    display_end();
    display_pick_texture(slidebar_texture);
    display_start_fan();
        display_texpos_xy(0.0f, 0.0f);  display_vertex_xy(90.0f+x,  5.0f+y);
        display_texpos_xy(1.0f, 0.0f);  display_vertex_xy(95.0f+x,  5.0f+y);
        display_texpos_xy(1.0f,12.03125f);  display_vertex_xy(95.0f+x, 295.0f+y);
        display_texpos_xy(0.0f,12.03125f);  display_vertex_xy(90.0f+x, 295.0f+y);
    display_end();
    display_blend_trans();
        fileslide_menu_item = current_menu_item;
        menu_vertical_slider(88.5f+x, y, &filelist_position, 1.0f);
    display_color_alpha(black);
    x = 3.0f+x;  y = menu_y + 6.0f;  y_add = 8.0f;
    firstfile = num_filelist;
    firstfile -= 36;
    if(firstfile < 0)
    {
        firstfile = 0;
    }
    else
    {
        firstfile = (int) (filelist_position*(firstfile+0.50f));
    }
    repeat(i, 36)
    {
        if((i + firstfile) < num_filelist)
        {
            display_string(filelist[i+firstfile], x, y, y_add, 14);  y+=y_add;
        }
    }
    y = menu_y + 5.0f;
    repeat(i, 36)
    {
        picked = FALSE;
        if((i + firstfile) < num_filelist)
        {
            menu_highlight_area(x, y, 80.0f, y_add, &picked, 255, 255, 255);  y+=y_add;
            if(picked)
            {
                if(filelist_settings)
                {
                    sprintf(global_settings_filename, "%s", filelist[i+firstfile]);
                }
                else
                {
                    sprintf(global_object_filename, "%s", filelist[i+firstfile]);
                }
                i = num_filelist;
            }
        }
    }
    display_blend_off();
    display_color_alpha(white);








    // Upper menu segment
    display_pick_texture(menu_texture[0]);
    y = menu_y*0.333f;
    display_start_fan();
        display_texpos_xy(0.0f, 0.01f);  display_vertex_xy(0.0f, 0.0f+y);
        display_texpos_xy(1.0f, 0.01f);  display_vertex_xy(100.0f, 0.0f+y);
        display_texpos_xy(1.0f, 0.99f);  display_vertex_xy(100.0f, 100.0f+y);
        display_texpos_xy(0.0f, 0.99f);  display_vertex_xy(0.0f, 100.0f+y);
    display_end();
    display_blend_trans();
    y = y+2.0f;
    x = 54.0f;
    y_add = 7.0f;
    current_menu_item = 0;
        menu_slider(x, y, &global_spring_force, 1.0f); y+=y_add;
        menu_slider(x, y, &global_toothpick_force, 1.0f); y+=y_add;
        menu_slider(x, y, &global_return_force, 1.0f); y+=y_add;
        menu_slider(x, y, &global_dampen, 1.0f); y+=y_add;
        y+=y_add;
        menu_slider(x, y, &global_scope_spring_force, 1.0f); y+=y_add;
        menu_slider(x, y, &global_scope_toothpick_force, 1.0f); y+=y_add;
        menu_slider(x, y, &global_scope_dampen, 1.0f); y+=y_add;
        menu_slider(x, y, &global_scope_radius, 10.0f); y+=y_add;
        menu_slider(x, y, &global_scope_weight, 1.0f); y+=y_add;
        y+=y_add;
        temp = global_scope_control_points;
        menu_slider(x, y, &temp, MAX_SCOPE_CONTROL); y+=y_add;
        global_scope_control_points = (unsigned short) temp;
        temp = global_scope_between_points;
        menu_slider(x, y, &temp, MAX_SCOPE_BETWEEN); y+=y_add;
        global_scope_between_points = (unsigned short) temp;
    display_blend_off();





    // Middle menu segment...
    display_pick_texture(menu_texture[1]);
    y = 100.0f + (menu_y*0.667f);
    display_start_fan();
        display_texpos_xy(0.0f, 0.01f);  display_vertex_xy(0.0f, 0.0f+y);
        display_texpos_xy(1.0f, 0.01f);  display_vertex_xy(100.0f, 0.0f+y);
        display_texpos_xy(1.0f, 0.99f);  display_vertex_xy(100.0f, 100.0f+y);
        display_texpos_xy(0.0f, 0.99f);  display_vertex_xy(0.0f, 100.0f+y);
    display_end();
    display_blend_trans();
    y = y-2.0f;
        menu_slider(x, y, &global_scope_stiffness, 1.0f); y+=y_add;
        menu_slider(x, y, &global_scope_turn_stiffness, 1.0f); y+=y_add;
        menu_slider(x, y, &global_scope_tip_stiffness, 1.0f); y+=y_add;
        menu_slider(x, y, &global_scope_max_tip_angle, 180.0f); y+=y_add;
        menu_slider(x, y, &global_ambient_light, 1.0f); y+=y_add;
        menu_slider(x, y, &global_cam_light, 1.0f); y+=y_add;
        if(menu_textbox(60.0f, y+9.0f, global_scope_length_text, 6, NULL, FALSE))
        {
            temp = global_scope_length;
            log_message("User attempted to set scope length to %s", global_scope_length_text);
            if(sscanf(global_scope_length_text, "%f", &global_scope_length) == 0)
            {
                global_scope_length = temp;
            }
            else
            {
                scope_initialize(global_scope_control_points, global_scope_length, global_scope_radius, 0.0f, 0.0f, global_scope_length/(global_scope_control_points+1));
            }
        }
        y+=21.0f;
        menu_slider(x, y, &global_gravity, 1.0f); y+=y_add;
        menu_textbox(20.0f, y+10.0f, global_settings_filename, 12, "FILES\\*.TXT", TRUE);
        y+=19.0f;
        if(menu_button(50.0f, y, button_texture[8], button_texture[9]))
        {
            menu_load_settings(global_settings_filename);
        }
        if(menu_button(3.0f, y, button_texture[10], button_texture[11]))
        {
            menu_save_settings(global_settings_filename);
        }
    display_blend_off();





    // Lower menu segment...
    display_pick_texture(menu_texture[2]);
    y = 200.0f+menu_y;
    display_start_fan();
        display_texpos_xy(0.0f, 0.01f);  display_vertex_xy(0.0f, 0.0f+y);
        display_texpos_xy(1.0f, 0.01f);  display_vertex_xy(100.0f, 0.0f+y);
        display_texpos_xy(1.0f, 0.99f);  display_vertex_xy(100.0f, 100.0f+y);
        display_texpos_xy(0.0f, 0.99f);  display_vertex_xy(0.0f, 100.0f+y);
    display_end();
    display_blend_trans();
    menu_textbox(20.0f, y+5.0f, global_object_filename, 12, "MODELS\\*.X", FALSE);
    menu_slider(x, y+13.0f, &global_object_scaling, 10.0f);
    display_blend_off();
    // The Load Mesh button
    y+=23.0f;
    if(menu_button(3.0f, y, button_texture[0], button_texture[1]))
    {
        global_load_inverted = FALSE;
        xfile_load_object(global_object_filename, global_load_inverted);
        scope_initialize(global_scope_control_points, global_scope_length, global_scope_radius, 0.0f, 0.0f, global_scope_length/(global_scope_control_points+1));
    }
    // The Load Inverted button
    if(menu_button(50.0f, y, button_texture[2], button_texture[3]))
    {
        global_load_inverted = TRUE;
        xfile_load_object(global_object_filename, global_load_inverted);
        scope_initialize(global_scope_control_points, global_scope_length, global_scope_radius, 0.0f, 0.0f, global_scope_length/(global_scope_control_points+1));
    }
    // The Save Mesh button
    y+=13.0f;
    if(menu_button(3.0f, y, button_texture[4], button_texture[5]))
    {
        object_export(global_object_filename);
    }
    // The From Scope button
    if(menu_button(50.0f, y, button_texture[6], button_texture[7]))
    {
        object_destroy_all();
        scope_create_object(24);
    }




    // The help button
    if(menu_button(353.0f, 288.5f, button_texture[12], button_texture[13]))
    {
        input_show_help();
    }





    x = 3.0f;
    y = menu_y + 254.0f;
    y_add = 7.0f;
    menu_highlight_area(x, y, 93.0f, y_add, &object_draw_hit, 0, 255, 0);  y=y+y_add;
    menu_highlight_area(x, y, 93.0f, y_add, &object_draw_wireframe, 0, 0, 255);  y=y+y_add;
    menu_highlight_area(x, y, 93.0f, y_add, &object_draw_spring, 255, 0, 0);  y=y+y_add;
    menu_highlight_area(x, y, 93.0f, y_add, &global_dll_active, 0, 0, 255);  y=y+y_add;
    menu_highlight_area(x, y, 93.0f, y_add, &global_scope_cam, 255, 0, 0);  y=y+y_add;
    menu_highlight_area(x, y, 93.0f, y_add, &menu_open, 255, 255, 0);  y=y+y_add;












    display_blend_trans();
    display_color_alpha(white);


//    sprintf(text, "Testing = %f", global_testing);
//    display_string(text, 100.0f, 50.0f, 20.0f, 255);


    if(global_scope_cam)
    {
        // For the camera mode...
        display_string("Scope Cam", 320.0f, 5.0f, 10.0f, 255);
    }
    else
    {
        // For the camera mode...
        display_string("External Camera", 280.0f, 5.0f, 10.0f, 255);
    }
    if(global_draw_tally_text)
    {
        sprintf(text, "Tally = %d", global_tally);
        display_string(text, 310.0f, 15.0f, 10.0f, 255);
        sprintf(text, "Time = %4.2f", global_tally_contact_time);
        display_string(text, 310.0f, 25.0f, 10.0f, 255);
    }
    if(global_draw_dll_text)
    {
        x = 110.0f;  y = 50.0f;  y_add = 10.0f;
        sprintf(text, "Whiteout %4.2f to %4.2f seconds", global_whiteout_min_seconds, global_whiteout_max_seconds);
        display_string(text, x, y, 10.0f, 255); y+=y_add;

        sprintf(text, "%4.2f percent chance of permanent", global_percent_chance_of_permanent_whiteout);
        display_string(text, x, y, 10.0f, 255); y+=y_add*2.0f;

        sprintf(text, "Object mesh settings...");
        display_string(text, x, y, 10.0f, 255); y+=y_add;

        repeat(object, num_object)
        {
            sprintf(text, "Object %d - %4.2f, %4.2f, %4.2f, %4.2f, %4.2f", object, object_dampen[object]*global_dampen, object_return_force[object]*global_return_force, object_spring_force[object]*global_spring_force, object_toothpick_force[object]*global_toothpick_force, object_weight[object]);
            display_string(text, x, y, 10.0f, 255); y+=y_add;
        }
        y+=y_add;

        // For the DLL inputs...
        sprintf(text, "Zin == %f", global_dll_zin);
        display_string(text, x, y, 10.0f, 255); y+=y_add;
        sprintf(text, "Zangle == %f", global_dll_zangle);
        display_string(text, x, y, 10.0f, 255); y+=y_add;
        sprintf(text, "HeadAngle == %f", global_dll_headangle);
        display_string(text, x, y, 10.0f, 255); y+=y_add;
        sprintf(text, "Degrees == %f", global_dll_degrees);
        display_string(text, x, y, 10.0f, 255); y+=y_add;
        sprintf(text, "TopDown == %f", global_dll_topdown);
        display_string(text, x, y, 10.0f, 255); y+=y_add;
        y+=y_add;

        sprintf(text, "T to hide Text");
        display_string(text, x, y, 10.0f, 255); y+=y_add;
    }

    display_blend_off();
    display_zbuffer_on();
}

//-----------------------------------------------------------------------------------------------
