// <ZZ> This file contains functions for handling the logfile.txt file
//      log_message             - Writes a message to the log file using printf style formatting
//      close_logfile           - Closes the logfile, automatically called via atexit()
//      open_logfile            - Opens the logfile
FILE* logfile;

//-----------------------------------------------------------------------------------------------
void make_uppercase(char *string)
{
    // <ZZ> This function changes all lowercase letters in string to be uppercase.
    int i;

    i = 0;
    while(string[i] != 0)
    {
        if(string[i] >= 'a' && string[i] <= 'z')  string[i] += 'A'-'a';
        i++;
    }
}

//-----------------------------------------------------------------------------------------------
void log_message(char *format, ...)
{
    // <ZZ> This function spits out a message to the logfile.txt file, following standard printf
    //      style formatting.  It also logs any errors to the message buffer (for ingame tools).
    va_list ap;
    char log_buffer[256];

    if(logfile)
    {
        va_start(ap, format);
        vsprintf(log_buffer, format, ap);
        va_end(ap);
        fprintf(logfile, "%s\n", log_buffer);
        fflush(logfile);
    }
}

//-----------------------------------------------------------------------------------------------
void close_logfile(void)
{
    // <ZZ> This function closes the logfile, and should be run automatically on program
    //      termination...
    if(logfile)
    {
        fclose(logfile);
    }
}

//-----------------------------------------------------------------------------------------------
signed char open_logfile(void)
{
    // <ZZ> This function opens up the LOGFILE.LOG file and registers close_logfile() to run
    //      on program termination.  It returns TRUE if it worked okay, FALSE if there was a
    //      problem.
    logfile = fopen("FILES\\LOGFILE.LOG", "w");
    if(logfile)
    {
        atexit(close_logfile);
        return TRUE;
    }
    return FALSE;
}

//-----------------------------------------------------------------------------------------------